unit mFibonacci;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, mAufrufe;

type
  TfrmMain = class(TForm)
    edN: TEdit;
    Label1: TLabel;
    edFib: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    btIterativ: TButton;
    btRekursiv: TButton;

    procedure btIterativClick(Sender: TObject);
    procedure btRekursivClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    hAusgabe : TfrmAufrufe;
    protokollieren : boolean;
    function FibRekursiv (n, stufe:integer):integer;
  public
    { Public-Deklarationen }
  end;

var
  frmMain: TfrmMain;

implementation{$R *.dfm}

function FibIterativ (n:integer):integer;
var i, f0, f1, f2 : integer;
begin
  if (n=0) or (n=1)
  then Result := n
  else begin
    f0:=0; f1:=1; f2:=f0+f1;
    for i := 2 to n do begin
      f0 := f1; f1 := f2; f2 := f0+ f1;
    end;
    Result := f1;
  end;
end;

function TfrmMain.FibRekursiv (n, stufe:integer):integer;
begin
  if protokollieren then hAusgabe.Eintrag(stufe,n);
  if (n=0) or (n=1)
  then Result := n
  else Result := FibRekursiv(n-1, stufe+1)+FibRekursiv(n-2, stufe+1);
end;

procedure TfrmMain.btIterativClick(Sender: TObject);
begin
  edFib.text := intToStr(FibIterativ(StrToInt(edN.Text)));
end;

procedure TfrmMain.btRekursivClick(Sender: TObject);
begin
  if protokollieren then hAusgabe.Clear;
  edFib.text := intToStr(FibRekursiv(StrToInt(edN.Text),1));
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  hAusgabe := TfrmAufrufe.Create(self);
  hAusgabe.Show;
  protokollieren := true;
end;

end.
